{ *********************************************************************** }
{                                                                         }
{ Delphi Visual Component Library                                         }
{                                                                         }
{ Copyright (c) 2001-2004 Borland Software Corporation                    }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.VarConv;

interface

uses
  Variants, ConvUtils;

//==============================================================================
function VarConvertCreate(const AValue: Double; const AType: TConvType): Variant; overload;
function VarConvertCreate(const AValue: string): Variant; overload;

function VarConvert: TVarType;
function VarIsConvert(const AValue: Variant): Boolean;
function VarAsConvert(const AValue: Variant): Variant; overload;
function VarAsConvert(const AValue: Variant; const AType: TConvType): Variant; overload;

implementation

uses
  Convert;

function VarConvertCreate(const AValue: Double; const AType: TConvType): Variant;
begin
   Result := Variant(TConvert.From(AValue, AType));
end;

function VarConvertCreate(const AValue: string): Variant;
begin
  Result := Variant(TConvert.From(AValue));
end;

var
  FVarType: TVarType;

function VarConvert: TVarType;
begin
  Result := FVarType;
end;

function VarIsConvert(const AValue: Variant): Boolean;
begin
  Result := TObject(AValue) is TConvert;
end;

function VarAsConvert(const AValue: Variant): Variant; overload;
begin
  if not VarIsConvert(AValue) then
    Result := VarAsType(AValue, VarConvert)
  else
    Result := AValue;
end;

function VarAsConvert(const AValue: Variant; const AType: TConvType): Variant;
begin
  if not VarIsConvert(AValue) then
    Result := VarConvertCreate(AValue, AType)
  else
    Result := AValue;
end;

initialization
  FVarType := RegisterCustomVariantType(TypeOf(TConvert));
end.

